(define (make-map-node)
  (make-hash))

(define map-root (make-map-node))

(define (insert key val)
  (let loop ([node map-root] [chars (string->list key)])
    (if (null? chars)
        (hash-set! node 'value val)
        (let ([c (car chars)])
          (unless (hash-has-key? node c)
            (hash-set! node c (make-map-node)))
          (loop (hash-ref node c) (cdr chars))))))

(define (sum-prefix prefix)
  (let loop ([node map-root] [chars (string->list prefix)])
    (if (null? chars)
        (sum-values node)
        (let ([c (car chars)])
          (if (hash-has-key? node c)
              (loop (hash-ref node c) (cdr chars))
              0)))))

(define (sum-values node)
  (let ([sum 0])
    (hash-for-each node (lambda (k v)
                          (if (eq? k 'value)
                              (set! sum (+ sum v))
                              (set! sum (+ sum (sum-values v))))))
    sum))

(define (map-sum pairs)
  (set! map-root (make-map-node))
  (for-each (lambda (pair)
              (insert (car pair) (cadr pair)))
            pairs)
  (sum-prefix ""))